s              }                                              tt1906      Thurlby Thandar 1906 Multimeter               R     Instrument Name: Thurlby Thandar 1906 Multimeter

 Description:     This instrument module provides
                  programming support for the
                  TTi 1906 multimeter.  The module
                  is divided into the following
                  functions:

 Functions/Classes:

 (1) Initialize
     Initialize the instrument and set to default
     configuration.

 (2) Configure
     Sets the measurement function and range and
     other minor parameters.
 (3) Measure
     Returns readings, max/min values or limit
     values.

 (4) Trigger
     Allows the instrument to be triggered to make
     a reading.

 (5) Programs
     This Class of functions gives access to the
     computational capabilities of the instrument.
     -Delta percent. Computes the offset about a
     reference value.
     -DB. Computes the readings in deci-Bels from
     a reference value
     -Ax+B. Performs scaling and offset
     calculations on the readings.
     -Limits. Compares Readings to reference
     limits.
     -Min/Max. Computes and stores the maximum and
     minimum readings over time.
     -Null. Uses the current reading to offset
     future readings.

 (6) Local Storage. Gives access to the local
     non-volatile stores in the instrument.

 (7) Status Reporting
     This class of functions gives access to the
     status reporting capabilities of the
     instrument.
     -Set Status. Determines how statue will be
     reported.
     -Get Status. Returns the requested status
     register value.

 (8) Miscellaneous
     This class of functions allows access to
     additional 1906 remote control commands
     which is not available elsewhere in this
     driver. Also included are file operations.
        (1) Send Command String
        (2) Get Response String
        (3) File Operations

 (9)  Close
     Take the instrument offline.    >      Class name:  Programms

  Description: Gives access to the computational
               capabilities of the instrument.

  Functions/class:

     -Delta percent. Computes the offset about a
     reference value.
     -DB. Computes the readings in deci-Bels from
     a reference value
     -Ax+B. Performs scaling and offset
     calculations on the readings.
     -Limits. Compares Readings to reference
     limits.
     -Min/Max. Computes and stores thr maximum and
     minimum readings over time.
     -Null. Uses the current reading to offset
     future readings.    D      Class name:  Status Reporting

  Description: This class of functions gives
               access to the status reporting
               capabilities of the instrument.

  Functions/class:

     -Set Status. Determines how statue will be
     reported.
     -Get Status. Returns the requested status
     register value.          Class name:  Miscellaneous

  Description: This class of functions allows
               access to additional 1906 remote
               control commands which is not
               available elsewhere in this driver.
               Also included are file operations.

  Functions/class:

        (1) Send Command String
        (2) Get Response String
        (3) File Operations
    (     Panel Name:    Initialize

 Description:   Initializes the instrument in the
                following ways:

                - opens the instrument and sets
                  its GPIB address to the speci-
                  fied value

                - performs an identification query
                  on the instrument

                - sets the instrument to a default
                  configuration

                - returns an instrument ID which
                  is used to identify the
                  instrument in subsequent calls.    P     Control Name:  Address

 Description:   Specifies the address on the
                GPIB to be used to communicate
                with the instrument.  This value
                must correspond to the current
                internal setting of the
                instrument.

 Variable Type: Integer

 Valid Range:   0 to 30

 Default Value: 1

 NOTE:  The Default Value of this control may be
        set to the factory default of the
        instrument, however if your actual
        instrument setting is changed this
        control's default should also also be
        changed.    
     Control Name:  Instrument ID

 Description:   Returns an Instrument ID that is
                used in all subsequent function
                calls to select the instrument at
                the Address specified.

                If more than one instrument of the
                same type is used, this value will
                be used to differentiate between
                them. The first instrument
                initialized will be assigned an
                Instrument ID of 1.

 Variable Type: Integer         Control Name:  ID Query

 Description:   Specifies if an ID Query is sent
                to the instrument during the
                initialization procedure.

 Variable Type: Integer

 Valid Range:   1 = Yes
                0 = No

 Default Value: 1 - Yes

 NOTE:  Under normal circumstances the ID Query
        insures that the instrument initialized
        over the GPIB is the type supported by
        this driver. However circumstances may
        arise where it is undesirable to send an
        ID Query to the instrument. In those
        cases; set this control to Skip Query
        and this function will initialize the
        GPIB and the Command arrays in the driver,
        without doing an ID Query.         Control Name:  Reset

 Description:   Specifies if the instrument is to
                be reset to its power-on settings
                during the initialization
                procedure.

 Variable Type: Integer

 Valid Range:   1 = Yes
                0 = No

 Default Value: 1 - Yes

 NOTE: If you do not want the instrument reset.
       Set this control to No while initializing
       the instrument.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   GPIB Address out of range
       -2   ID Query out of range
       -3   Reset Device out of range

      220   Unable to open instrument
      221   Unable to close instrument
      223   Instrument identification query failed
      224   Error clearing instrument
      225   Error triggering instrument
      226   Error polling instrument
      228   Error writing to instrument from file
      229   Error reading from instrument to file
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      234   Error placing instrument in local mode
      236   Error interpreting instrument response
      239   Error configuring time out
      240   Instrument timed out

      3xx   Instrument Specific errors

 NOTES: (1) This control should be all the way
            down and one space out of the lower
            right corner of all function panels.

        (2) When finished with the instrument
            driver, each function panel should
            have all unused error codes deleted.    % - g           Address                           } -          Instrument ID                       K          ID Query                          k            Reset Device                                Error                                                                     / 8                                            1    	           Do Query 1 Skip Query 0   Reset Device 1 Don't Reset 0    	            (Instrument driver version 2.0 Apr. 1995    Copyright (c) TTi Ltd.    y     Panel Name:    Configure  Function/Range

 Description:   Configures the instrument to take
                readings.
    `     Control Name:  Function

 Description:   Sets the measurement function of
                the instrument

 Variable Type: Integer

 Valid Range:   0 = Volts DC
                1 = Volts AC
                2 = mA DC
                3 = mA AC
                4 = 10A DC
                5 = 10A AC
                6 = Ohms

 Default value: 0 - Volts DC    N     Control Name:  Range

 Description:   Sets the measurement range. If the
                range is illegal for the selected
                function an error will be
                returned. Unsuported combinations
                such as 21kV are detected by this
                driver and no command will be sent
                to the instrument in these cases.
                See the Error control for a full
                list of errors.

 Variable Type: Integer

 Valid Range:   0 = 210,mV,uA, Ohms
                1 = 2.1, V,mA,kOhms
                2 =  21, V,mA,kOhms
                3 = 210, V,mA,kOhms
                4 = 2.1,kV.--.MOhms
                5 =  21,--,--,MOhms
                6 = Autoranging
                7 = Manual - locks instrument to
                    the present range

 Default Value: 6 - Autoranging


          Control Name:  Resolution

 Description:   Selects 4.5 or 5.5 digit mode

 Variable Type: Integer

 Valid Range:   0 = 5.5
                1 = 4.5

 Default Value: 0 - 5.5    i     Control Name:  Filter

 Description:   Set the digital reading filter to
                one of the ten possibilities
                described in the instrument
                manual.

 Variable Type: Integer

 Valid Range:   0 to 9

 default Value: 0 - uses the defaut values
                    optimised for each range and
                    function.
    $     Control Name:  Hi Z

 Description:   Sets very high input impedance
                (>1 GOhm) for the 210mV and 2.1V
                DC ranges. Has no effect on other
                ranges.

 Variable Type: Integer

 Valid Range:   0 = Off
                1 = On

 Default Value: 0 - Off
    _     Control Name:  Trigger Set

 Description:   Set the type of reading trigger to
                use when the instrument is
                triggered.
                Note: The Read control on the
                Measure panel must be set to
                Triggered for this control to have
                any effect. The filter setting on
                this panel also determines how
                the readings will be made if this
                control is set to filtered.

 Variable Type: Integer

 Valid Range:   0 = Filtered
                1 = Next Reading

 Default Value: 1 - Next Reading
    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.         Control Name:  Cancel All Programs

 Description:   If set to Yes all computational
                operations will be set to their
                inactive state.

 Variable Type: Integer

 Valid Range:   0 = No
                1 = Yes

 Default Value: 0 - No         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   ID Query out of range
       -2   Function value out of range
       -3   Range value out of range
       -4   Resolution value out of range
       -5   Hi Z value out of range
       -6   Filter value out of range
       -7   Trigger Set value out of range
       -8   Cancel value out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response
      240   Instrument timed out

      319   Range value illegal for the selected
            function
     - P          Function                          ! -           Range                             $a -"          Resolution                        % .|          Filter                            & }$          Hi Z                              ' }x          Trigger Set                       *             Instrument ID                     ,{            Cancel All Programs               -          Error                                         ?Volts DC 0 Volts AC 1 mA DC 2 mA AC 3 10A DC 4 10A AC 5 Ohms 6               u210mV,uA,Ohms 0 2.1V,mA,kOhms 1 21V,mA,kOhms 2 210V,mA,kOhms 3 2.1kV,-,MOhms 4 21 ,  ,MOhms 5 Autoranging 6 Manual 7    4.5dig 1 5.5dig 0    0    On 1 Off 0   Nxt Reading 1 Filtered 0    1    Yes 1 No 0    	            n     Panel Name:    Measure

 Description:   Returns readings, max/min values
                or limit values.

    A     Control Name:  Read

 Description:   Selects the type of reading to
                return.

 Variable Type: Integer

 Valid Range:   0 = Immediate (Note 1)
                1 = Triggered (Note 2)
                2 = Limits    (Note 3)
                3 = Min/Max   (Note 4)

 Default Value: 0 - immediate

 Notes:
        (1) Immediate returns the next reading
        immediately after the command is received.
        The reading is placed in both the Result
        Numeric and Result String variables
        (2) Triggered returns the next reading
        after the instrument is triggered, See the
        Trigger Panel for more information.
        (3) Returns the results of the Limits
        program in the Result String variable.
        (4) Returns the recorded Min and Max
        values in the Result String variable.    x     Control Name:  Result Numeric

 Description:   Contains the result of an
                Immediate read command. This
                variable will contain zero for any
                other Read operation.

 Variable Type: Double

 Note:  To receive the result of a Triggered Read
        you must execute the Trigger panel and use
        the values returned from there.
         Control Name:  Result String

 Description:   Contaims the response string data
                from Immediate, Limits and Min/Max
                Read operations. An empty string
                will result from a Triggered Read
                operation.

 Variable Type: String

 Note:  To receive the result of a Triggered Read
        you must execute the Trigger panel and use
        the values returned from there.    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   ID Query out of range
       -2   Read control value out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response
      240   Instrument timed out
    3 =           Read                              7H =          Result Numeric                    8 =U         Result String                     :y             Instrument ID                     <          Error                                         +Immediate 0 Triggered 1 Limits 2 Min/Max 3    	           	            1    	                 Panel Name:    Trigger

 Description:   Triggers the instrument to make a
                reading then reads the result.

 Note:  Before executing this function a Triggered
        Read must have been executed from the
        Measure function    1     Control Name:  Result Numeric

 Description:   Contains the result of an
                Triggered read command.

 Variable Type: Double

 Note:  Before executing this function a Triggered
        Read must have been executed from the
        Measure function if not Error 231 will be
        returned
    >     Control Name:  Result String

 Description:   Contaims the response string data
                from a Triggered Read command

 Variable Type: String

 Note:  Before executing this function a Triggered
        Read must have been executed from the
        Measure function if not Error 231 will be
        returned
    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   ID Query out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response
      240   Instrument timed out
    A =          Result Numeric                    B< =+         Result String                     C             Instrument ID                     E          Error                              	           	            1    	            n     Panel Name:    Delta percent

 Description:   Computes the offset about a
                reference value.
          Control Name:  Enable

 Description:   Sets the Delta Percent
                computational program of or on.

 Variable Type: Integer

 Valid Range:   0 = Off
                1 = On
                2 = On and configure

 Default Valeu: 0 - Off         Control Name:  Reference Value

 Description:   Sets the reference value for the
                Delta Percent program.

 Variable Type: Double

 Valid Range:   Range/Function dependent

 Default Value: 0.0

 Note: This value is ignored if the Enable is set
       to Off or On.    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   ID Query out of range
       -2   Enable value out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response
      240   Instrument timed out

      319   Reference value out of range    H M           Enable                            I M         Reference Value                   K	             Instrument ID                     Mi          Error                                         Off 0 On 1 On + config. 2    0.0    1    	            p     Panel Name:    DB

 Description:   Computes the readings in deci-Bels
                from a reference value
          Control Name:  Enable

 Description:   Sets the DB computational
                program of or on.

 Variable Type: Integer

 Valid Range:   0 = Off
                1 = On
                2 = On and configure

 Default Valeu: 0 - Off         Control Name:  Reference Value

 Description:   Sets the reference value for the
                DB program.

 Variable Type: Double

 Valid Range:   0.001 to 9.999

 Default Value: 1.0

 Note: This value is ignored if the Enable is set
       to Off or On.    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   ID Query out of range
       -2   Enable value out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response
      240   Instrument timed out

      319   Reference value out of range    P M           Enable                            Q M         Reference Value                   R             Instrument ID                     U9          Error                                         Off 0 On 1 On + config. 2    1.0    1    	            r     Panel Name:    Ax+B

 Description:   Performs scaling and offset
                calculations on the readings.
          Control Name:  Enable

 Description:   Sets the Ax+B computational
                program of or on.

 Variable Type: Integer

 Valid Range:   0 = Off
                1 = On
                2 = On and configure

 Default Valeu: 0 - Off          Control Name:  A

 Description:   Sets the A value for the Ax+B
                program.

 Variable Type: Double

 Valid Range:   -999999 to +999999

 Default Value: 1.0

 Note: This value is ignored if the Enable is set
       to Off or On.          Control Name:  B

 Description:   Sets the B value for the Ax+B
                program.

 Variable Type: Double

 Valid Range:   Range/Function dependent

 Default Value: 0.0

 Note: This value is ignored if the Enable is set
       to Off or On.    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   ID Query out of range
       -2   Enable value out of range
       -3   The A value is out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response
      240   Instrument timed out

      319   The B value is out of range    X M z          Enable                            Y M          A                                 Z M\         B                                 [             Instrument ID                     ]          Error                                         Off 0 On 1 On + config. 2    1.0    0.0    1    	            a     Panel Name:    Limits

 Description:   Compares Readings to reference
                limits.
          Control Name:  Enable

 Description:   Sets the Limits computational
                program of or on.

 Variable Type: Integer

 Valid Range:   0 = Off
                1 = On
                2 = On and configure

 Default Valeu: 0 - Off         Control Name:  Low Limit

 Description:   Sets the Low Limit value for the
                Limits program.

 Variable Type: Double

 Valid Range:   Range/Function dependent

 Default Value: 0.0

 Note: This value is ignored if the Enable is set
       to Off or On.    
     Control Name:  Hign Limit

 Description:   Sets the High Limitvalue for the
                Limits program.

 Variable Type: Double

 Valid Range:   Range/Function dependent

 Default Value: 0,0

 Note: This value is ignored if the Enable is set
       to Off or On.    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   ID Query out of range
       -2   Enable value out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response
      240   Instrument timed out

      319   Low or High value is out of range    a M z          Enable                            b M          Low Limit                         c M\         High Limit                        d             Instrument ID                     gD          Error                                         Off 0 On 1 On + config. 2    0.0    0.0    1    	            y     Panel Name:    Min/Max

 Description:  Computes and stores the maximum and
               minimum readings over time.
          Control Name:  Enable

 Description:   Sets the Min Max computational
                program of or on.

 Variable Type: Integer

 Valid Range:   0 = Off
                1 = On

 Default Valeu: 0 - Off    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.    T     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   ID Query out of range
       -2   Enable value out of range

      230   Error writing to instrument
      232   Instrument not initialized
      240   Instrument timed out    j ]          Enable                            k             Instrument ID                     n2          Error                                         Off 0 On 1    1    	            l     Panel Name:    Null

 Description:   Uses the current reading to offset
                future readings.
          Control Name:  Enable

 Description:   Sets the Null computational
                program of or on.

 Variable Type: Integer

 Valid Range:   0 = Off
                1 = On

 Default Valeu: 0 - Off    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   ID Query out of range
       -2   Enable value out of range

      230   Error writing to instrument
      232   Instrument not initialized
      240   Instrument timed out

      321   In porgram - see instrument manual for
            more information    p ]          Enable                            q             Instrument ID                     s          Error                                         Off 0 On 1    1    	                 Panel Name:    Local Storage

 Description:   Gives access to the local
                non-volatile stores in the
                instrument.
          Control Name:  Operation

 Description:   Selects the recall or store
                operation.

 Variable Type: Integer

 Valid Range:   0 = Recall
                1 = Store

 Default Value: 0 - Recall         Control name:   Store Number

Description:    Select the number of the store to
                Recall from or Store to.

Variable type:  integer

Valid range:    0 to 5

Default value:  1
    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   instrument ID out of range
       -2   Operation value out of range
       -3   Store Number out of range

      230   Error writing to instrument
      232   Instrument not initialized
      240   Instrument timed out    w M           Operation                         w M          Store Number                      x             Instrument ID                     {          Error                                         Recall 0 Store 1    1    1    	            f     Panel Name:    Set Status

 Description:   Determines how status will be
                reported.
    <    Control name:   Set Status Enable

Description:    Used to select which enable
                register will receive the byte
                value.

Variable type:  integer

Valid range:    0 = SRQ enable
                1 = Standard Event Enable
                2 = Parallel Poll

Default value   0 - SRQ Enable
         Control name:   Value

Description:    A byte value which will be written
                to the selected enable register.

Variable type:  integer

Valid range:    0 to 255

Default value:  0
    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   instrument ID out of range
       -2   Status Enable value out of range
       -3   Register Value out of range

      230   Error writing to instrument
      232   Instrument not initialized
      240   Instrument timed out    ~
 M           Set Status Enable                 Q M          Value                                          Instrument ID                     |          Error                                         +SRQ enable 0 Event Enable 1 Parallel Pol 2    0    1    	            k     Panel Name:    Get Status

 Description:   Returns the requested status
                register value.
        Control name:   Read Status

Description:    Used to select which status
                register to read

Variable type:  integer

Valid range:    0 = Status Byte
                1 = Standard Event Status
                2 = SRQ enable
                3 = Standard Event Enable
                4 = Parallel Poll Enable
                5 = Execution Error Register

Default value   0 - Status Byte

         Control name:   Value

Description:    Returns the value read from the
                selected register.

Variable type:  Integer    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   instrument ID out of range
       -2   Status Enable value out of range
       -3   Register Value out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response
      240   Instrument timed out     M           Read Status                       < M$          Value                                          Instrument ID                     (          Error                                         SStatus byte 0 Std Event 1 SRQ enable 2 Event Enable 3 Parallel Pol 4 Exec. Error 5    	            1    	                 Panel Name:    Send Command String

 Description:   Sends a string of bytes to the
                instrument from a string variable.
         Control name:   Command String

Description:    This control specifies data to be
                sent to the 1906. The absolute
                maximum length allowed is 200
                bytes.

Variable type:  String    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.    3     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   instrument ID out of range

      230   Error writing to instrument
      232   Instrument not initialized
      240   Instrument timed out     ]          Command                                        Instrument ID                     @          Error                                  1    	            ~     Panel Name:    Get Response String

 Description:   Reads a response from the 1906
                into a string variable.
        Control name:   Response Stirng

Description:    This control specifies a string
                variable to receive the response
                from the 1906. The string must
                be long enough to receive the
                response to avoid overflow. To aid
                in checking this the number of
                bytes put into the string is
                returned from the function. The
                absolute maximum length allowed is
                2000 bytes.

Variable type:  String         Control name:   Number of Bytes

Description:    This value is the number of bytes
                returned by the 1906 and
                placed in the string.

Variable type:  Integer    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.    5     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   instrument ID out of range

      231   Error reading from instrument
      232   Instrument not initialized
      240   Instrument timed out     M          Response                           M          Number Of Bytes                                Instrument ID                               Error                              	            	            1    	                 Panel Name:    File Operations

 Description:   Send or Receive a binary block to
                or from the 1906. The data will
                be read from or written to a file.

          Control Name:  Operation

 Description:   Selects to send a file to the
                1906 or Get a file from 1906.

 Variable Type: Integer

 Valid Range:   0 = Send file to 1906
                1 = Get file from 1906

 Default Value: 0 - Send file         Control name:   File name

Description:    This control specifies file name
                from which the binary block will
                be sent to the 1906.

Variable type:  String - max length 50 characters    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   instrument ID out of range
       -2   Operation value out of range

      228   Error writing to instrument from file
      229   Error reading from instrument to file
      232   Instrument not initialized
      240   Instrument timed out     ]           Operation                          ]         File Name                                      Instrument ID                     &          Error                                         Send File 0 Get File 1        1    	                 Panel Name:    Close

 Description:   Closes the instrument and takes it
                off line.

 Note: The  instrument must  be reinitialized
       to use it again.    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range

      221   Unable to close instrument
      232   Instrument not initialized                 Instrument ID                               Error                              1    	                         K.    init                                     "  0w 	    K.    config                                   3  >     K.    measure                                  @  Gv     K.    trig                                     Hs  OL     K.    delta                                    Pa  W     K.    db                                       X1  `	     K.    axb                                      aZ  i,     K.    limits                                   j}  o     K.    minmax                                   pX  u     K.    null                                     vt  |     K.    store                                    }       K.    set_stat                                 0       K.    get_stat                                 h  {     K.    send_cmd                                 /  $     K.    get_resp                                 !       K.    file                                            K.    close                                                                       DInitialize                           DConfigure Function/Range             DMeasure                              DTrigger                             Programs                             DDelta Percent                        DDB                                   DAx+B                                 DLimits                               DMin/Max                              DNull                                 DLocal Storage                       
 Status Reporting                     DSet Status                           DGet Status                          lMiscellaneous                        DSend Command String                  DGet Respinse String                  DFile Operations                      DClose                           